// GrabItDlg.cpp : implementation file
//
/*
Changelog 1.2:
	fixed a bug that made item at 5 o'clock say 11 o'clock


TO DO:
	tomb management
		if scroll goes into the inv, drop it

??	graceful exit if d2 is closed first - not sure what the problem is
	pk shutdown
	option: write to screen when picking up
	logging option
	pickup corpse
	expanded item filter (normal,socket)
	potion management (vbm)
	mundane item management (expanded vbm)
	seperate rares, uniques, sets
*/

#include "stdafx.h"
#include "GrabIt.h"
#include "GrabItDlg.h"
#include "HelpDlg.h"
#include "About.h"
#include "Options.h"

#include "Mouse.h"
#include "MessageRead.h"
#include <fstream.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CGrabItDlg dialog

//<MFC>  MFC creates this functions automatically, no need to touch them - CN


CGrabItDlg::CGrabItDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGrabItDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGrabItDlg)
	m_iSetRange = 0;
	m_checkPick = FALSE;
	m_sFilterValue = _T("");
	m_Priority = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);


	m_thrRead = NULL ;
	m_Capturing = FALSE ;
	m_DLL_Loaded = FALSE ;
	m_HitSpin = FALSE ;


	// get the filter values from file if it exists
	FILE*	fTest = fopen("GrabIt.ini", "r") ;
	BOOL	bOpen = (fTest != NULL) ;
	if ( bOpen) {
		fclose(fTest) ;
		m_FilterNEW.RetrieveValues() ;
	} else {
		m_FilterNEW.PreCannedValues() ;
	}


	// get the options from file if it exists
	fTest = fopen("GrabItOptions.ini", "r") ;
	bOpen = (fTest != NULL) ;
	if ( bOpen) {
		fclose(fTest) ;
		RetrieveOptions() ;
	} else {
		PreCannedOptions() ;
	}
	m_GfxLiteOrig = m_GfxLite ;
	

	m_FilterNEW.LoadBMPs( m_GfxLite) ;
}


CGrabItDlg::~CGrabItDlg()
{
	if ( m_thrRead != NULL) {

		HANDLE thread = m_thrRead->m_hThread;

		//kill the capture thread.
		BOOL res=TerminateThread(thread,0);
		
		if(res==false){
			AfxMessageBox("Fatal Error: cannot terminate the capture thread"); 
		}

		//wait the end of the capture thread
		WaitForSingleObject(thread,INFINITE);

	}		

	delete m_pPacketInfo ;
	delete m_thrRead ;

	// delete all the memory taken up by the items
	while(!m_DropClass.m_Drops.IsEmpty()) {
		CNormalDrop* pItem = (CNormalDrop*)m_DropClass.m_Drops.RemoveHead();
		delete pItem ;
	}
}

void CGrabItDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGrabItDlg)
	DDX_Control(pDX, IDC_BTTNUBER, m_bttnUber);
	DDX_Control(pDX, IDC_RUNEPIC, m_RunePic);
	DDX_Control(pDX, IDC_FILTERSLIDE, m_slideFilter);
	DDX_Control(pDX, IDC_SPINRANGE, m_spinRange);
	DDX_Control(pDX, IDC_BTTNTP, m_bttnTP);
	DDX_Control(pDX, IDC_BTTNRUNE, m_bttnRune);
	DDX_Control(pDX, IDC_BTTNRING, m_bttnRing);
	DDX_Control(pDX, IDC_BTTNREJUV, m_bttnRejuv);
	DDX_Control(pDX, IDC_BTTNMANA, m_bttnMana);
	DDX_Control(pDX, IDC_BTTNJEWEL, m_bttnJewel);
	DDX_Control(pDX, IDC_BTTNID, m_bttnID);
	DDX_Control(pDX, IDC_BTTNHEAL, m_bttnHeal);
	DDX_Control(pDX, IDC_BTTNCHARM, m_bttnCharm);
	DDX_Control(pDX, IDC_BTTNGEM, m_bttnGem);
	DDX_Control(pDX, IDC_BTTNGOLD, m_bttnGold);
	DDX_Control(pDX, IDC_BTTNSKULL, m_bttnSkull);
	DDX_Control(pDX, IDC_TYPELIST, m_typeList);
	DDX_Text(pDX, IDC_SETRANGE, m_iSetRange);
	DDV_MinMaxInt(pDX, m_iSetRange, 4, 24);
	DDX_Check(pDX, IDC_CHECKPICK, m_checkPick);
	DDX_Text(pDX, IDC_FILTERVALUE, m_sFilterValue);
	DDV_MaxChars(pDX, m_sFilterValue, 4);
	DDX_Text(pDX, IDC_PRIORITY, m_Priority);
	DDV_MinMaxInt(pDX, m_Priority, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGrabItDlg, CDialog)
	//{{AFX_MSG_MAP(CGrabItDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_LBN_SELCHANGE(IDC_TYPELIST, OnSelchangeTypelist)
	ON_EN_KILLFOCUS(IDC_SETRANGE, OnKillfocusSetrange)
	ON_BN_CLICKED(IDC_CHECKPICK, OnCheckpick)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPINRANGE, OnDeltaposSpinrange)
	ON_EN_CHANGE(IDC_SETRANGE, OnChangeSetrange)
	ON_BN_CLICKED(IDC_BTTNGOLD, OnBttnGold)
	ON_BN_CLICKED(IDC_BTTNHEAL, OnBttnHeal)
	ON_BN_CLICKED(IDC_BTTNMANA, OnBttnMana)
	ON_BN_CLICKED(IDC_BTTNREJUV, OnBttnRejuv)
	ON_BN_CLICKED(IDC_BTTNRUNE, OnBttnRune)
	ON_BN_CLICKED(IDC_BTTNRING, OnBttnJewlry)
	ON_BN_CLICKED(IDC_BTTNGEM, OnBttnGem)
	ON_BN_CLICKED(IDC_BTTNSKULL, OnBttnSkull)
	ON_BN_CLICKED(IDC_BTTNJEWEL, OnBttnJewel)
	ON_BN_CLICKED(IDC_BTTNCHARM, OnBttnCharm)
	ON_BN_CLICKED(IDC_BTTNTP, OnBttnTP)
	ON_BN_CLICKED(IDC_BTTNID, OnBttnID)
	ON_BN_CLICKED(IDC_DELFILTER, OnDelFilter)
	ON_BN_CLICKED(IDC_ADDFILTER, OnAddFilter)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_SAVEBUTTON, OnSaveButton)
	ON_BN_CLICKED(IDC_HELPBUTTON, OnHelpButton)
	ON_BN_CLICKED(IDC_BTTNUBER, OnBttnUber)
	ON_BN_CLICKED(IDC_OPTIONSBUTTON, OnOptionsButton)
	ON_EN_KILLFOCUS(IDC_PRIORITY, OnKillfocusPriority)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CGrabItDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CGrabItDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//</MFC>




/////////////////////////////////////////////////////////////////////////////
// CGrabItDlg message handlers



///
/// CORE: Initialization, Painting, Timer
///

BOOL CGrabItDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here


	// load the buttons on to the bitmaps
	m_buttonbmp[ 0].LoadBitmap( IDB_GOLD);
	m_buttonbmp[ 1].LoadBitmap( IDB_RUNE);

	m_bttnGold.SetBitmap(  m_buttonbmp[0]) ;
	m_bttnHeal.SetBitmap(  m_FilterNEW.m_FilterBMPs[ ITEM_HEALING5]) ;
	m_bttnMana.SetBitmap(  m_FilterNEW.m_FilterBMPs[ ITEM_MANA5]) ;
	m_bttnRejuv.SetBitmap( m_FilterNEW.m_FilterBMPs[ ITEM_REJUV2]) ;
	m_bttnRune.SetBitmap(  m_buttonbmp[1]) ;
	m_bttnRing.SetBitmap(  m_FilterNEW.m_FilterBMPs[ ITEM_JEWLRY]) ;
	m_bttnGem.SetBitmap(   m_FilterNEW.m_FilterBMPs[ ITEM_GEM5]) ;
	m_bttnSkull.SetBitmap( m_FilterNEW.m_FilterBMPs[ ITEM_SKULL5]) ;
	m_bttnJewel.SetBitmap( m_FilterNEW.m_FilterBMPs[ ITEM_JEWELS]) ;
	m_bttnCharm.SetBitmap( m_FilterNEW.m_FilterBMPs[ ITEM_CHARMS]) ;
	m_bttnTP.SetBitmap(    m_FilterNEW.m_FilterBMPs[ ITEM_TP]) ;
	m_bttnID.SetBitmap(    m_FilterNEW.m_FilterBMPs[ ITEM_ID]) ;


	// set the spin control properties (range of 4 to 24)
	m_spinRange.SetRange( 4, 24 );
	m_spinRange.SetBase( 10 );


	CAboutDlg	dlg ;
	dlg.DoModal() ;

	// display the screen if this is the first time running the program
	if (!m_CheckStartup)
		OnHelpButton() ;

	// set the random seed
	srand( (unsigned)time( NULL ) );

	// we'll be looking once 20 times per second to see if there are any items we should grab
	m_diablo2_ph = 0 ;
	SetTimer( 5301, 50, NULL) ;

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}


// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CGrabItDlg::OnPaint() 
{
	// this is crap added by MFC, but what the heck, I'll leave it
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);


	// this what we use to do any drawing or screen updates
	} else {

		CPaintDC dc(this); // device context for painting
		CDC		memdc;

		// Create a compatible memory DC
		memdc.CreateCompatibleDC( &dc );


		// draw the filters
		m_FilterNEW.DrawFilter( ITEM_GOLD1,    ITEM_GOLD5,    1, 11, TRUE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_HEALING1, ITEM_HEALING5, 2, 11, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_MANA1,    ITEM_MANA5,    3, 11, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_REJUV1,   ITEM_REJUV2,   4, 11, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_RUNE1,    ITEM_RUNE5,    5, 11, TRUE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_JEWLRY,   ITEM_JEWLRY,   6, 11, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_GEM1,     ITEM_GEM5,     7, 13, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_SKULL1,   ITEM_SKULL5,   8, 13, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_JEWELS,   ITEM_JEWELS,   9, 13, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_CHARMS,   ITEM_CHARMS,  10, 13, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_TP,       ITEM_TP,      11, 13, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_ID,       ITEM_ID,      12, 13, FALSE, &memdc, &dc, m_GfxLite) ;
		m_FilterNEW.DrawFilter( ITEM_UBER,     ITEM_UBER,    13, 13, TRUE, &memdc, &dc, m_GfxLite) ;

		CDialog::OnPaint();
	}
}


void CGrabItDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default


	// if the dll hasn't be loaded, check again; the intention here is so that users
	//	can hit the "start" button in the D2 chat room and not have to enter a game first to
	//	load the DLL - this way we can view their items as they enter the game too
	if ( !m_DLL_Loaded) {

		// if it's been loaded, then start the reader thread and toggle so we don't come back here

		// need to have the game running!
		if (m_diablo2_ph == 0) {
			m_diablo2_ph = GetProcessHandle("Diablo II", "Diablo II") ;
			if (m_diablo2_ph == 0) {
				return ;
			}
		}
		if (ReadProcessDWORD(m_diablo2_ph, 0x6FAB43EA) != 0) {
			m_pPacketInfo = new CReadThreadParams;
			m_pPacketInfo->prg = this;
			m_pPacketInfo->diablo2_ph = m_diablo2_ph ;
			m_thrRead = AfxBeginThread(MyThreadProc, m_pPacketInfo);

			m_DLL_Loaded = TRUE ;
			m_Capturing = TRUE ;

		} else
			return ;
	}
	m_DropClass.m_DelayTime = 0 ;


	// if the user disabled via hot key, don't do anymore pickups
	if (!m_Capturing) {
		return ;

	// need to process uber drop delay times and pick up FIRST if ready
	} else if ((m_DropClass.m_NumValidUbers > 0) && (!m_DropClass.m_PreventSpam)) {
		// suspend the reader thread so we don't have data collisions between it and the main thread
		m_thrRead->SuspendThread() ;

		m_DropClass.PickUpUber() ;

		m_thrRead->ResumeThread() ;

	// if there is nothing to pick up, do garbage collection
	} else if (( m_DropClass.m_NumValidUbers == 0) && (!m_DropClass.m_DropsUber.IsEmpty())) {
		// suspend the reader thread so we don't have data collisions between it and the main thread
		m_thrRead->SuspendThread() ;

		m_DropClass.m_DropsUber.RemoveAll() ;

		// loop through the list and delete invalid items
		while(!m_DropClass.m_DropsUber.IsEmpty()) {
			CUberDrop* pItem = (CUberDrop*)m_DropClass.m_DropsUber.RemoveHead();
			delete pItem ;
		}

		m_thrRead->ResumeThread() ;
	}


	// if we have something to send to battle.net, then we'll do it here
	if ((m_DropClass.m_NumValidItems > 0) && (!m_DropClass.m_PreventSpam)) {

		// suspend the reader thread so we don't have data collisions between it and the main thread
		m_thrRead->SuspendThread() ;

		m_DropClass.PickUpItem() ;

		m_thrRead->ResumeThread() ;

	// if there is nothing to pick up, do garbage collection
	} else if (( m_DropClass.m_NumValidItems == 0) && (!m_DropClass.m_Drops.IsEmpty())) {
		// suspend the reader thread so we don't have data collisions between it and the main thread
		m_thrRead->SuspendThread() ;

		m_DropClass.m_DropsValid.RemoveAll() ;

		// loop through the list and delete invalid items
		while(!m_DropClass.m_Drops.IsEmpty()) {
			CNormalDrop* pItem = (CNormalDrop*)m_DropClass.m_Drops.RemoveHead();
			delete pItem ;
		}
		// just in case
		m_DropClass.m_PreventSpam = FALSE ;

		m_thrRead->ResumeThread() ;

	} else {
		m_DropClass.m_PreventSpam = FALSE ;
	}

	CDialog::OnTimer(nIDEvent);
}



///
/// GUI interactions
///

void CGrabItDlg::UpdateRangeGUI( BOOL bInRange) 
{
	GetDlgItem( IDC_STATICRANGE)->EnableWindow(bInRange) ;
	GetDlgItem( IDC_SETRANGE)->EnableWindow(bInRange) ;
	GetDlgItem( IDC_SPINRANGE)->EnableWindow(bInRange) ;
	GetDlgItem( IDC_STATICPRI)->EnableWindow(bInRange) ;
	GetDlgItem( IDC_PRIORITY)->EnableWindow(bInRange) ;
	m_checkPick = bInRange ;

	UpdateData( FALSE) ;
}


// made a new item selection in the list box
void CGrabItDlg::OnSelchangeTypelist() 
{
	// TODO: Add your control notification handler code here

	// get the filter index and display so we can display the range
	int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
	m_iSetRange = m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange ;
	m_Priority = m_FilterNEW.m_Filter[iFilter].m_PriorityColor ;


	// update the GUI depending upon if it's to be picked up
	UpdateRangeGUI( m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange >= 4) ;	
}


// enabled/disabled picking up this guality of item
void CGrabItDlg::OnCheckpick() 
{
	// TODO: Add your control notification handler code here


	// get the filter that is selected
	int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;

	// if they want to pick this item up, set to min range (cascade)
	if (!m_checkPick) {
		
		//cascade add for every type above this one
		for (int i=iFilter; i<=m_FilterNEW.m_Filter[ iFilter].m_CascadeMax; i++)
			if (m_FilterNEW.m_Filter[ i].m_MaxPickRange < 4)
				m_FilterNEW.m_Filter[ i].m_MaxPickRange = 4 ;
		m_iSetRange = 4 ;

	// if they want to NOT pick this item up, set to 0 (cascade)
	} else if (m_checkPick) {

		//cascade remove for every type below this one
		for (int i=iFilter; i>=m_FilterNEW.m_Filter[ iFilter].m_CascadeMin; i--)
			m_FilterNEW.m_Filter[ i].m_MaxPickRange = 0 ;
		m_iSetRange = 0 ;
	}

	// set the GUI
	UpdateRangeGUI( !m_checkPick) ;
	Invalidate(TRUE) ;
}


// used to mark if someone hit the spin buttons; m_HitSpin used in OnChangeSetrange
void CGrabItDlg::OnDeltaposSpinrange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here


	// set the toggle
	m_HitSpin = TRUE ;

	
	*pResult = 0;
}


// used when someone hit the spin buttons
void CGrabItDlg::OnChangeSetrange() 
{
	// TODO: Add your control notification handler code here

	
	// only want to do anything here if the spin control was used, if there was typing in
	//	the text box, then that will be handled when it loses the focus
	if (m_HitSpin) {
		m_HitSpin = FALSE ;		// reset the toggle

		// retrieve the data from the screen, and select the filter for the array
		UpdateData(TRUE) ;

		//cascade add/remove for every type above/below this one
		int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
		m_FilterNEW.CascadeUpdate( iFilter, m_iSetRange) ;

		// redraw the screen to show our changes
		Invalidate() ;
	}
}


// when the user is done typing in the range, update
void CGrabItDlg::OnKillfocusSetrange()
{
	// TODO: Add your control notification handler code here

	// if the update is successful, continue (entered and int 4 to 24)
	if (UpdateData(TRUE)) {

		//cascade add/remove for every type above/below this one
		int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
		m_FilterNEW.CascadeUpdate( iFilter, m_iSetRange) ;

		// redraw the screen to show our changes
		Invalidate() ;
	}
}


void CGrabItDlg::OnKillfocusPriority() 
{
	// TODO: Add your control notification handler code here
	
	// if the update is successful, continue (entered and int 0 to 5)
	if (UpdateData(TRUE)) {
		int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
//CN - am I doing this right?
		m_FilterNEW.m_Filter[iFilter].m_PriorityColor = m_Priority ;
	}
}



///
/// Filter Buttons Clicked GUI
///

void CGrabItDlg::ListBoxGUI(int iFilter)
{
	switch ( iFilter) {
//	case ITEM_GOLD1:
	case ITEM_HEALING1:
		SetDlgItemText( IDC_ITEMTYPE, "Healing Potion Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Minor Healing"), ITEM_HEALING1 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Light Healing"), ITEM_HEALING2 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Healing"), ITEM_HEALING3 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Greater Healing"), ITEM_HEALING4 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Super Healing"), ITEM_HEALING5 ) ;
		m_typeList.SelectString(-1, "Minor Healing") ;
		break ;
	case ITEM_MANA1:
		SetDlgItemText( IDC_ITEMTYPE, "Mana Potion Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Minor Mana"), ITEM_MANA1 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Light Mana"), ITEM_MANA2 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Mana"), ITEM_MANA3 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Greater Mana"), ITEM_MANA4 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Super Mana"), ITEM_MANA5 ) ;
		m_typeList.SelectString(-1, "Minor Mana") ;
		break ;
	case ITEM_REJUV1:
		SetDlgItemText( IDC_ITEMTYPE, "Rejuvination Potion Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Rejuvination"), ITEM_REJUV1 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Full Rejuvination"), ITEM_REJUV2 ) ;
		m_typeList.SelectString(-1, "Rejuvination") ;
		break ;
//	case ITEM_RUNE1:
	case ITEM_JEWLRY:
		SetDlgItemText( IDC_ITEMTYPE, "Ring/Amulet Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Rings and Amulets"), ITEM_JEWLRY ) ;
		m_typeList.SelectString(-1, "Rings and Amulets") ;
		break ;
	case ITEM_GEM1:
		SetDlgItemText( IDC_ITEMTYPE, "Gem Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Chipped Gem"), ITEM_GEM1 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Flawed Gem"), ITEM_GEM2 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Normal Gem"), ITEM_GEM3 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Flawless Gem"), ITEM_GEM4 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Perfect Gem"), ITEM_GEM5 ) ;
		m_typeList.SelectString(-1, "Chipped Gem") ;
		break ;
	case ITEM_SKULL1:
		SetDlgItemText( IDC_ITEMTYPE, "Skull Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Chipped Skull"), ITEM_SKULL1 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Flawed Skull"), ITEM_SKULL2 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Skull"), ITEM_SKULL3 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Flawless Skull"), ITEM_SKULL4 ) ;
		m_typeList.SetItemData( m_typeList.AddString("Perfect Skull"), ITEM_SKULL5 ) ;
		m_typeList.SelectString(-1, "Chipped Skull") ;
		break ;
	case ITEM_JEWELS:
		SetDlgItemText( IDC_ITEMTYPE, "Jewel Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Jewels"), ITEM_JEWELS ) ;
		m_typeList.SelectString(-1, "Jewels") ;
		break ;
	case ITEM_CHARMS:
		SetDlgItemText( IDC_ITEMTYPE, "Charm Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Charms"), ITEM_CHARMS ) ;
		m_typeList.SelectString(-1, "Charms") ;
		break ;
	case ITEM_TP:
		SetDlgItemText( IDC_ITEMTYPE, "TP Scroll Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Town Portals"), ITEM_TP ) ;
		m_typeList.SelectString(-1, "Town Portals") ;
		break ;
	case ITEM_ID:
		SetDlgItemText( IDC_ITEMTYPE, "ID Scroll Filters") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Identification"), ITEM_ID ) ;
		m_typeList.SelectString(-1, "Identification") ;
		break ;
	case ITEM_UBER:
		SetDlgItemText( IDC_ITEMTYPE, "Rare, Set, Unique Filter") ;
		m_typeList.ResetContent() ;
		m_typeList.SetItemData( m_typeList.AddString("Rare, Set, Unique"), ITEM_UBER ) ;
		m_typeList.SelectString(-1, "Rare, Set, Unique") ;
		break ;
	}



	// hide these, except for runes
	GetDlgItem( IDC_RUNENAME)->ShowWindow(FALSE) ;
	GetDlgItem( IDC_RUNEPIC)->ShowWindow(FALSE) ;

	// enable the list and the pickup check box
	GetDlgItem( IDC_ITEMTYPE)->EnableWindow() ;
	GetDlgItem( IDC_TYPELIST)->EnableWindow() ;
	GetDlgItem( IDC_CHECKPICK)->EnableWindow() ;
	GetDlgItem( IDC_ADDFILTER)->EnableWindow(FALSE) ;
	GetDlgItem( IDC_DELFILTER)->EnableWindow(FALSE) ;
	GetDlgItem( IDC_FILTERVALUE)->EnableWindow(FALSE) ;
	GetDlgItem( IDC_FILTERSLIDE)->EnableWindow(FALSE) ;
	GetDlgItem( IDC_STATICCUSTOM)->EnableWindow(FALSE) ;

	GetDlgItem( IDC_TYPELIST)->SetFocus() ;

	m_iSetRange = m_FilterNEW.m_Filter[iFilter].m_MaxPickRange ;
	m_spinRange.SetPos( m_iSetRange );
	m_Priority = m_FilterNEW.m_Filter[iFilter].m_PriorityColor ;


	// update the GUI depending upon if it's to be picked up
	UpdateRangeGUI( m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange >= 4) ;
}


void CGrabItDlg::OnBttnGold() 
{
	// TODO: Add your control notification handler code here

	char	sTmp[10] ;
	int		iFirst = -1 ;
	int		iNumFilters = 0 ;

	SetDlgItemText( IDC_ITEMTYPE, "Gold Filters (5 max)") ;
	m_typeList.ResetContent() ;
	for (int item=ITEM_GOLD1; item<=ITEM_GOLD5; item++) {
		if ( m_FilterNEW.m_Filter[ item].m_FilterValue > 0) {
			sprintf(sTmp,"%d", m_FilterNEW.m_Filter[ item].m_FilterValue) ;
			m_typeList.SetItemData( m_typeList.AddString( sTmp), item ) ;
			if (iFirst == -1) {
				m_typeList.SelectString(-1, sTmp) ;
				iFirst = item ;
			}
			iNumFilters++ ;
		}
	}

	// GUI for the first item in the list
	ListBoxGUI( iFirst) ;

	m_slideFilter.SetRange(1, 9999);
	m_slideFilter.SetTicFreq(500);
	m_slideFilter.SetPos(1);
	UpdateData(FALSE) ;
	SetDlgItemText( IDC_FILTERVALUE, "") ;

	GetDlgItem( IDC_STATICCUSTOM)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_ADDFILTER)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_FILTERSLIDE)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_FILTERVALUE)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_DELFILTER)->EnableWindow(iNumFilters > 0) ;
	GetDlgItem( IDC_CHECKPICK)->EnableWindow(iNumFilters > 0) ;
}

void CGrabItDlg::OnBttnRune() 
{
	// TODO: Add your control notification handler code here
	
	int		iFirst = -1 ;
	int		iNumFilters = 0 ;

	SetDlgItemText( IDC_ITEMTYPE, "Rune Filters (5 max)") ;
	m_typeList.ResetContent() ;
	for (int item=ITEM_RUNE1; item<=ITEM_RUNE5; item++) {
		if ( m_FilterNEW.m_Filter[ item].m_FilterValue > 0) {
			CString sTmp ;
			sTmp.Format("%s  (#%d) & up", m_FilterNEW.GetRuneName(m_FilterNEW.m_Filter[ item].m_FilterValue), m_FilterNEW.m_Filter[ item].m_FilterValue) ;
			m_typeList.SetItemData( m_typeList.AddString( sTmp), item ) ;
			if (iFirst == -1) {
				m_typeList.SelectString(-1, sTmp) ;
				iFirst = item ;
			}
			iNumFilters++ ;
		}
	}

	// GUI for the first item in the list
	ListBoxGUI( iFirst) ;

	GetDlgItem( IDC_RUNENAME)->ShowWindow(TRUE) ;
	GetDlgItem( IDC_RUNEPIC)->ShowWindow(!m_GfxLite) ;

	m_slideFilter.SetRange(1, 33);
	m_slideFilter.SetTicFreq(3);
	m_slideFilter.SetPos(1);
	UpdateData(FALSE) ;
	SetDlgItemText( IDC_FILTERVALUE, "") ;

	GetDlgItem( IDC_STATICCUSTOM)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_ADDFILTER)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_FILTERSLIDE)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_FILTERVALUE)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_RUNENAME)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_RUNEPIC)->EnableWindow(iNumFilters < 5) ;
	GetDlgItem( IDC_DELFILTER)->EnableWindow(iNumFilters > 0) ;
	GetDlgItem( IDC_CHECKPICK)->EnableWindow(iNumFilters > 0) ;
}

// click the heal filter button
void CGrabItDlg::OnBttnHeal()	{	ListBoxGUI( ITEM_HEALING1) ;}

void CGrabItDlg::OnBttnMana()	{	ListBoxGUI( ITEM_MANA1) ;}

void CGrabItDlg::OnBttnRejuv()	{	ListBoxGUI( ITEM_REJUV1) ;}

void CGrabItDlg::OnBttnJewlry() {	ListBoxGUI( ITEM_JEWLRY) ;}

void CGrabItDlg::OnBttnGem()	{	ListBoxGUI( ITEM_GEM1) ;}

void CGrabItDlg::OnBttnSkull()	{	ListBoxGUI( ITEM_SKULL1) ;}

void CGrabItDlg::OnBttnJewel()	{	ListBoxGUI( ITEM_JEWELS) ;}

void CGrabItDlg::OnBttnCharm()	{	ListBoxGUI( ITEM_CHARMS) ;}

void CGrabItDlg::OnBttnTP()		{	ListBoxGUI( ITEM_TP) ;}

void CGrabItDlg::OnBttnID()		{	ListBoxGUI( ITEM_ID) ;}

void CGrabItDlg::OnBttnUber() 
{
	ListBoxGUI( ITEM_UBER) ;

	if ( m_Penalty)
		MessageBox("NOTE: There is a random delay penalty of 2 seconds on average before grabbing ubers.") ;
}

void CGrabItDlg::OnAddFilter() 
{
	// TODO: Add your control notification handler code here

//STILL HAPPENS???????????????????????????????????????????????????????
//cn BUG WHEN THERE IS NOTHING LEFT AND ITS A RUNE
//CN USING THE EXIT BUTTON SEEMS TO NOT WORK AND THEN CRASH

	int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
	BOOL bGotInt ;
	int iValue = GetDlgItemInt( IDC_FILTERVALUE, &bGotInt, FALSE) ;

	//
	CString retString = m_FilterNEW.AddSpecialFilter( iFilter, iValue, bGotInt) ;
	if ( retString == "ERROR")
		return ;

	// set as much of the GUI as possible
	m_typeList.SelectString(-1, retString) ;
	m_sFilterValue = "" ;
	UpdateData(FALSE) ;


//cn ONCE THE FILTER CLASS IS FINISHED, MAKE SURE THIS WORKS!!! NEED TO SET MAXPICK
	// after the update, no get the we can get the filter info
	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
	if (m_FilterNEW.m_Filter[ iFilter].m_CascadeMin == ITEM_GOLD1)
		OnBttnGold() ;
	else
		OnBttnRune() ;
	m_iSetRange = m_FilterNEW.m_Filter[ iFilter].m_MaxPickRange ;
	UpdateData(FALSE) ;


	Invalidate() ;
}

void CGrabItDlg::OnDelFilter() 
{
	// TODO: Add your control notification handler code here
	
	// select the filter index for the array
	UpdateData(FALSE) ;
	int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;


	if ( m_FilterNEW.DelSpecialFilter( iFilter) == ITEM_GOLD1)
		OnBttnGold() ;
	else
		OnBttnRune() ;

	Invalidate() ;
}

void CGrabItDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default

	// this could ONLY be the filterslide, get for which filter
	int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
	int val = m_slideFilter.GetPos() ;

	if (m_FilterNEW.m_Filter[ iFilter].m_CascadeMin == ITEM_GOLD1) {
		m_sFilterValue.Format("%d", val) ;
		UpdateData(FALSE) ;

	} else if (m_FilterNEW.m_Filter[ iFilter].m_CascadeMin == ITEM_RUNE1) {

		SetDlgItemText( IDC_RUNENAME, m_FilterNEW.UpdateRunePic( val, m_GfxLite)) ;
		m_RunePic.SetBitmap( m_FilterNEW.m_RuneBMP) ;
		
		m_sFilterValue.Format("%d", val) ;
		UpdateData(FALSE) ;
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}



///
/// saving and changing configuration and options
///

void CGrabItDlg::OnSaveButton() 
{
	// TODO: Add your control notification handler code here
	
	if (MessageBox("Existing data will be overwritten.  Continue?", "Save", MB_YESNO) == IDYES) {
		FILE* fout = fopen("GrabIt.ini", "w") ;
		fprintf( fout, "GrabIt1.1\n") ;
		for (int i=ITEM_GOLD1; i<NUM_ITEMS; i++)
			fprintf( fout, "%d	%d	%d\n", m_FilterNEW.m_Filter[ i].m_MaxPickRange, m_FilterNEW.m_Filter[ i].m_FilterValue, m_FilterNEW.m_Filter[ i].m_PriorityColor) ;
		fclose( fout) ;
	}
}


void CGrabItDlg::OnHelpButton() 
{
	// TODO: Add your control notification handler code here
	
	CHelpDlg dlgHelp;
	BOOL	bStartUpOrig = m_CheckStartup ;
	dlgHelp.m_CheckStartup = m_CheckStartup;
	if ( dlgHelp.DoModal() == IDOK) {
		m_CheckStartup = dlgHelp.m_CheckStartup ;

		// if they toggled the startup option, save changes
		if ( bStartUpOrig != m_CheckStartup)
			SaveOptions() ;
	}
}


void CGrabItDlg::PreCannedOptions()
{
	// display help
	m_CheckStartup = FALSE ;
	m_GrabEars = FALSE ;
	m_GrabPlayerDrops = FALSE ;
	m_GfxLite = FALSE ;
	m_Passive = FALSE ;
	m_Penalty = TRUE ;
//	m_HotKeyOnOff = 'G' ;
	m_DropClass.m_ColorLag = 10 ;
	m_ColorNot = 0 ;
	m_PriorityColor[0] = 9 ;
	m_PriorityColor[1] = 8 ;
	m_PriorityColor[2] = 1 ;
	m_PriorityColor[3] = 11 ;
	m_PriorityColor[4] = 3 ;
	m_DropClass.m_LagPerYard = 110 ;
}


void CGrabItDlg::RetrieveOptions()
{
	// display help
	ifstream	fin ;
	fin.open("GrabItOptions.ini") ;
	int iValue = 0 ;

	char	sVersion[15] ;
	fin >> sVersion ;
	BOOL bCurrent = (strcmp(sVersion,"GrabIt1.1") == 0) ;

	fin >> iValue ;
	m_CheckStartup = (iValue == 1) ;

	fin >> iValue ;
	m_GrabEars = (iValue == 1) ;

	fin >> iValue ;
	m_GrabPlayerDrops = (iValue == 1) ;

	fin >> iValue ;
	m_GfxLite = (iValue == 1) ;

	fin >> iValue ;
	m_Passive = (iValue == 1) ;

	fin >> iValue ;
	m_Penalty = (iValue == 1) ;

	fin >> iValue ;
	m_ColorNot = iValue ;

	fin >> iValue ;
	m_DropClass.m_ColorLag = iValue ;

	fin >> iValue ;
	m_DropClass.m_LagPerYard = iValue ;

	for (int i=0;i<5;i++) {
		fin >> iValue ;
		m_PriorityColor[i] = iValue ;
	}

//	fin >> iValue ;
//.	m_HotKeyOnOff = (iValue == 1) ;


	fin.close() ;
}


void CGrabItDlg::SaveOptions() 
{
	FILE* fout = fopen("GrabItOptions.ini", "w") ;
	fprintf( fout, "GrabIt1.1\n") ;
	fprintf( fout, "%d\n", m_CheckStartup) ;
	fprintf( fout, "%d\n", m_GrabEars) ;
	fprintf( fout, "%d\n", m_GrabPlayerDrops) ;
	fprintf( fout, "%d\n", m_GfxLite) ;
	fprintf( fout, "%d\n", m_Passive) ;
	fprintf( fout, "%d\n", m_Penalty) ;
	fprintf( fout, "%d\n", m_ColorNot) ;
	fprintf( fout, "%d\n", m_DropClass.m_ColorLag) ;
	fprintf( fout, "%d\n", m_DropClass.m_LagPerYard) ;
	
	for (int i=0;i<5;i++)
		fprintf( fout, "%d\n", m_PriorityColor[i]) ;
	fclose( fout) ;
}


void CGrabItDlg::OnOptionsButton() 
{
	// TODO: Add your control notification handler code here

	COptions	dlg ;
	dlg.m_ShowHelp = m_CheckStartup ;
	dlg.m_Ears = m_GrabEars ;
	dlg.m_PlayerDrops = m_GrabPlayerDrops ;
	dlg.m_GfxLite = m_GfxLite ;
	dlg.m_Passive = m_Passive ;
	dlg.m_Penalty = m_Penalty ;
	dlg.m_ColorLag = m_DropClass.m_ColorLag ;
	dlg.m_ColorNot = m_ColorNot ;
	dlg.m_LagPerYard = m_DropClass.m_LagPerYard/10 ;
	for (int i=0;i<5;i++)
		dlg.m_PriorityColor[i] = m_PriorityColor[i] ;

	if ( dlg.DoModal() == IDOK) {
		m_GrabEars = dlg.m_Ears ;
		m_GrabPlayerDrops = dlg.m_PlayerDrops ;
		m_CheckStartup = dlg.m_ShowHelp ;
		m_GfxLite = dlg.m_GfxLite ;
		m_Passive = dlg.m_Passive ;
		m_Penalty = dlg.m_Penalty ;
		m_DropClass.m_ColorLag = dlg.m_ColorLag ;
		m_ColorNot = dlg.m_ColorNot ;
		m_DropClass.m_LagPerYard = dlg.m_LagPerYard*10 ;

		for (int i=0;i<5;i++)
			m_PriorityColor[i] = dlg.m_PriorityColor[i] ;

		if (m_GfxLite != m_GfxLiteOrig)
			MessageBox("Changes to graphics will not take place until GrabIt is restarted.", "Graphics Lite") ;
		SaveOptions() ;
	}
}
